(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     36566,        870]
NotebookOptionsPosition[     36003,        847]
NotebookOutlinePosition[     36347,        862]
CellTagsIndexPosition[     36304,        859]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Savijanje", " ", "u", " ", "x"}], "-", 
    RowBox[{"z", " ", "ravni"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N1xz", "[", "x_", "]"}], ":=", 
   TagBox[
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"3", " ", "*", 
       SuperscriptBox["x", "2"]}], 
      SuperscriptBox["L", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["x", "3"]}], 
      SuperscriptBox["L", "3"]]}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";", 
  RowBox[{
   RowBox[{"N2xz", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"-", "x"}], "+", 
    FractionBox[
     RowBox[{"2", " ", "*", 
      SuperscriptBox["x", "2"]}], "L"], "-", 
    FractionBox[
     SuperscriptBox["x", "3"], 
     SuperscriptBox["L", "2"]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"N3xz", "[", "x_", "]"}], ":=", 
    TagBox[
     RowBox[{"\[InvisibleSpace]", 
      TagBox[
       RowBox[{
        FractionBox[
         RowBox[{"3", " ", "*", 
          SuperscriptBox["x", "2"]}], 
         SuperscriptBox["L", "2"]], "-", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["x", "3"]}], 
         SuperscriptBox["L", "3"]]}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ";", 
   RowBox[{
    RowBox[{"N4xz", "[", "x_", "]"}], ":=", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "2"], "L"], "-", 
     FractionBox[
      SuperscriptBox["x", "3"], 
      SuperscriptBox["L", "2"]]}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Savijanje", " ", "u", " ", "x"}], "-", 
    RowBox[{"y", " ", "ravni"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N1xy", "[", "x_", "]"}], ":=", 
   TagBox[
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"3", "*", " ", 
       SuperscriptBox["x", "2"]}], 
      SuperscriptBox["L", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", "*", 
       SuperscriptBox["x", "3"]}], 
      SuperscriptBox["L", "3"]]}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";", 
  RowBox[{
   RowBox[{"N2xy", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "-", 
    FractionBox[
     RowBox[{"2", " ", "*", 
      SuperscriptBox["x", "2"]}], "L"], "+", 
    FractionBox[
     SuperscriptBox["x", "3"], 
     SuperscriptBox["L", "2"]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N3xy", "[", "x_", "]"}], ":=", 
   TagBox[
    RowBox[{"\[InvisibleSpace]", 
     TagBox[
      RowBox[{
       FractionBox[
        RowBox[{"3", "*", " ", 
         SuperscriptBox["x", "2"]}], 
        SuperscriptBox["L", "2"]], "-", 
       FractionBox[
        RowBox[{"2", "*", " ", 
         SuperscriptBox["x", "3"]}], 
        SuperscriptBox["L", "3"]]}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";", 
  RowBox[{
   RowBox[{"N4xy", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["x", "2"], "L"]}], "+", 
    FractionBox[
     SuperscriptBox["x", "3"], 
     SuperscriptBox["L", "2"]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matricaNxz", ":=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"N1xz", "[", "x", "]"}], ",", 
      RowBox[{"N2xz", "[", "x", "]"}], ",", 
      RowBox[{"N3xz", "[", "x", "]"}], ",", 
      RowBox[{"N4xz", "[", "x", "]"}]}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matricaNxy", ":=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"N1xy", "[", "x", "]"}], ",", 
      RowBox[{"N2xy", "[", "x", "]"}], ",", 
      RowBox[{"N3xy", "[", "x", "]"}], ",", 
      RowBox[{"N4xy", "[", "x", "]"}]}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qz", ":=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"matricaNxz", "\[Transpose]"}], "*", "qz"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "L"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Qy", ":=", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"matricaNxy", "\[Transpose]"}], "*", "qy"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "L"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Jednako", " ", "podeljeno", " ", "opterecenje", " ", "upravno", " ", "na",
     " ", "osu", " ", "stapa"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Qz = \!\(\*SubsuperscriptBox[\(\[Integral]\), \(0\), \
\(L\)]\)\!\(\*SuperscriptBox[\(Nxz\), \(T\)]\)qz\[DifferentialD]x = qzL\>\"", 
    ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Qz", "/", 
      RowBox[{"(", 
       RowBox[{"qz", "*", "L"}], ")"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Qy = \!\(\*SubsuperscriptBox[\(\[Integral]\), \(0\), \
\(L\)]\)\!\(\*SuperscriptBox[\(Nxy\), \(T\)]\)qy\[DifferentialD]x = qyL\>\"", 
     ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Qy", "/", 
       RowBox[{"(", 
        RowBox[{"qy", "*", "L"}], ")"}]}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Koncentrisana", " ", "sila", " ", "upravno", " ", "na", " ", "osu", " ", 
    "stapa"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qz", ":=", 
   RowBox[{
    RowBox[{"Fz", "*", 
     RowBox[{"matricaNxz", "\[Transpose]"}]}], "/.", 
    RowBox[{"x", "\[Rule]", "a"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qy", ":=", 
   RowBox[{
    RowBox[{"Fy", "*", 
     RowBox[{"matricaNxy", "\[Transpose]"}]}], "/.", 
    RowBox[{"x", "\[Rule]", "a"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Qz = \!\(\*SuperscriptBox[\(Nxz\), \(T\)]\)(a)*Fz = Fz\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Qz", "/", "Fz"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Qy = \!\(\*SuperscriptBox[\(Nxy\), \(T\)]\)(a)*Fy = Fy\>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Qy", "/", "Fy"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Koncentrisani", " ", "moment"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qz", ":=", 
   RowBox[{"My", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"matricaNxz", "\[Transpose]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}], "/.", 
      RowBox[{"x", "\[Rule]", "a"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qy", ":=", 
   RowBox[{"Mz", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"matricaNxy", "\[Transpose]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}], "/.", 
      RowBox[{"x", "\[Rule]", "a"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Qz = -\!\(\*FractionBox[\(\*SuperscriptBox[\(dNxz\), \(T\)] \
\((a)\)\), \(dx\)]\)*My = My\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Qz", "/", "My"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Qy = -\!\(\*FractionBox[\(\*SuperscriptBox[\(dNxy\), \(T\)] \
\((a)\)\), \(dx\)]\)*Mz = Mz\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Qy", "/", "Mz"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Exit", "[", "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.671285218561768*^9, 3.6712852224778795`*^9}, {
   3.6712853507781982`*^9, 3.6712853533627048`*^9}, {3.6712855156956444`*^9, 
   3.6712856569865522`*^9}, {3.67128569827171*^9, 3.6712858122335777`*^9}, {
   3.671285854529786*^9, 3.6712859397580795`*^9}, 3.671286029911565*^9, {
   3.67128621048756*^9, 3.671286417539914*^9}, {3.671286456937516*^9, 
   3.671286511641947*^9}, {3.6712865498084764`*^9, 3.671286641308779*^9}, {
   3.671286679408077*^9, 3.671286680392885*^9}, {3.6712868347312326`*^9, 
   3.6712870316508045`*^9}, {3.6712870631202908`*^9, 3.671287172719783*^9}, {
   3.671287218035914*^9, 3.6712872453120375`*^9}, {3.6712872857306986`*^9, 
   3.671287480913745*^9}, {3.67128760822691*^9, 3.671287615294515*^9}, {
   3.671287658983341*^9, 3.671287664085622*^9}, {3.671287720015352*^9, 
   3.6712878112462034`*^9}, {3.6712878430778933`*^9, 3.671288010857177*^9}, {
   3.6712880484430227`*^9, 3.6712880832353263`*^9}, {3.6712881190409427`*^9, 
   3.6712882842351017`*^9}, {3.671288322262892*^9, 3.6712886145514774`*^9}, {
   3.6712886499296465`*^9, 3.6712886964168*^9}, {3.6712887356531954`*^9, 
   3.6712887796809597`*^9}, {3.671288846683859*^9, 3.6712888540468025`*^9}, {
   3.671289010278998*^9, 3.6712890786229305`*^9}, {3.671289116596269*^9, 
   3.671289336057767*^9}, {3.6712893733520656`*^9, 3.6712894058850164`*^9}, {
   3.671289450951722*^9, 3.671289516751732*^9}, {3.6712895713626103`*^9, 
   3.6712897779221067`*^9}, {3.6712898803641434`*^9, 
   3.6712899069621696`*^9}, {3.6712900872947817`*^9, 3.671290110523388*^9}, {
   3.671290142906954*^9, 3.671290242433835*^9}, {3.6712907191559258`*^9, 
   3.6712907227028365`*^9}, {3.6712915529308906`*^9, 
   3.6712915541158876`*^9}, {3.6712915849831967`*^9, 
   3.6712915884658127`*^9}, {3.6712918668742604`*^9, 
   3.6712918948896437`*^9}, {3.6713638866615114`*^9, 
   3.6713639267959366`*^9}, {3.6713639654021297`*^9, 3.671364108649173*^9}, {
   3.671364163210293*^9, 3.671364170181383*^9}, 3.6713642026152887`*^9, 
   3.6713642576706853`*^9, {3.6713643072988725`*^9, 3.671364539558816*^9}, {
   3.671364580433095*^9, 3.6713645989780054`*^9}, {3.6713647080053787`*^9, 
   3.6713647472653875`*^9}, {3.6713647778689423`*^9, 3.6713647784323025`*^9}, 
   3.6713648706601353`*^9, {3.6713649157743363`*^9, 3.671364916136832*^9}, {
   3.6713649473896675`*^9, 3.671364998649497*^9}, {3.6713650955230904`*^9, 
   3.6713651050399957`*^9}, {3.671365304869897*^9, 3.6713653248734503`*^9}, {
   3.671365354956499*^9, 3.6713653614089217`*^9}, {3.671365396020467*^9, 
   3.671365431412361*^9}, {3.6713654780513506`*^9, 3.671365521483403*^9}, {
   3.6713656732056217`*^9, 3.6713659212539225`*^9}, {3.671426518830373*^9, 
   3.671426525233269*^9}, 3.6714287068397655`*^9, {3.671428786127144*^9, 
   3.6714290469730606`*^9}, {3.671429101185466*^9, 3.671429201742052*^9}, {
   3.6714292352273717`*^9, 3.6714295850957856`*^9}, {3.6714296261887064`*^9, 
   3.6714297386068506`*^9}, {3.6714298174260864`*^9, 
   3.6714299139989605`*^9}, {3.671429946369828*^9, 3.671430025053458*^9}, {
   3.671430127188923*^9, 3.6714301348898635`*^9}, {3.6714301675355024`*^9, 
   3.6714301754536324`*^9}, {3.6714302211518545`*^9, 
   3.6714302342866035`*^9}, {3.6714302971772575`*^9, 3.671430340191184*^9}, {
   3.6714303791610184`*^9, 3.671430514436394*^9}, {3.67143054776044*^9, 
   3.6714306941138363`*^9}, {3.67143072654454*^9, 3.671430787511629*^9}, {
   3.671430818112608*^9, 3.671430833862881*^9}, {3.6714308660799475`*^9, 
   3.671430915889324*^9}, {3.6714309575975437`*^9, 3.6714310728734055`*^9}, {
   3.6714311042117524`*^9, 3.6714312116814103`*^9}, {3.671431269408288*^9, 
   3.6714313044500866`*^9}, {3.671431343225231*^9, 3.671431460818014*^9}, {
   3.6714315468062344`*^9, 3.6714316679798098`*^9}, {3.671432607804248*^9, 
   3.67143261573612*^9}, {3.671432655148446*^9, 3.6714326693864384`*^9}, {
   3.6714327090149155`*^9, 3.6714327532863674`*^9}, 3.6714339513679667`*^9, {
   3.671433988026251*^9, 3.671434093947483*^9}, {3.763137903706073*^9, 
   3.763138041650906*^9}, {3.763138096572361*^9, 3.7631382938334846`*^9}, {
   3.7631384420250063`*^9, 3.7631384796986523`*^9}, {3.7631392353193474`*^9, 
   3.763139433653572*^9}, {3.763139465214839*^9, 3.7631394872758894`*^9}, {
   3.763139834414278*^9, 3.7631398463852167`*^9}, {3.7631407027974806`*^9, 
   3.7631407652519827`*^9}, {3.7631524329567213`*^9, 3.763152501210246*^9}, {
   3.763152599548993*^9, 3.7631526113962007`*^9}, {3.7631530633199873`*^9, 
   3.763153118304477*^9}, {3.7631531934100866`*^9, 3.763153219267393*^9}, {
   3.763153249297134*^9, 3.763153331208663*^9}, {3.7631534243632274`*^9, 
   3.7631534402547474`*^9}, {3.763153479966256*^9, 3.7631535547698326`*^9}, {
   3.7631536014894977`*^9, 3.763153697446889*^9}, {3.7631537406693535`*^9, 
   3.763153957290066*^9}, {3.763173718137683*^9, 3.763173941177992*^9}, {
   3.7631740157537346`*^9, 3.763174077477674*^9}, {3.763174118138451*^9, 
   3.763174129138678*^9}, {3.7631741774135823`*^9, 3.7631741819575887`*^9}, {
   3.763174265965129*^9, 3.763174292762229*^9}, {3.7631743661433477`*^9, 
   3.7631744042943277`*^9}, {3.763174437463439*^9, 3.7631744379154267`*^9}, {
   3.7631744874330993`*^9, 3.7631747138340263`*^9}, {3.7631747977594814`*^9, 
   3.763174836705417*^9}, {3.7631748829665966`*^9, 3.7631749820636*^9}, {
   3.763175013118411*^9, 3.76317506526147*^9}, {3.7631751054097996`*^9, 
   3.763175242721301*^9}, {3.7631752977104874`*^9, 3.7631753064816275`*^9}, {
   3.763175339105661*^9, 3.7631754680268106`*^9}, {3.7631755107289705`*^9, 
   3.763175563158538*^9}, {3.763175615858033*^9, 3.76317562869396*^9}, {
   3.7631756713805604`*^9, 3.763175688057948*^9}, {3.7631757570232544`*^9, 
   3.763175813801959*^9}, {3.763175871258485*^9, 3.7631759208103323`*^9}, {
   3.763175978355275*^9, 3.763176251812273*^9}, {3.7631763170115457`*^9, 
   3.763176463710334*^9}, {3.7631765091910114`*^9, 3.76317658535999*^9}, {
   3.76317666108634*^9, 3.763176687332631*^9}, {3.7631767194697695`*^9, 
   3.7631768522502084`*^9}, {3.7631768835983686`*^9, 3.763176919676401*^9}, {
   3.7631770062680855`*^9, 3.763177034064331*^9}, {3.7631770763452*^9, 
   3.763177191118123*^9}, {3.7631772895241737`*^9, 3.7631773860217204`*^9}, {
   3.7631775173669996`*^9, 3.76317764547651*^9}, {3.763177778701894*^9, 
   3.76317795597614*^9}, {3.76317799367813*^9, 3.7631781031721935`*^9}, {
   3.7631782469044333`*^9, 3.7631782538616548`*^9}, {3.763178876008583*^9, 
   3.7631789595251846`*^9}, 3.763179000185196*^9, {3.7631790476456757`*^9, 
   3.7631791033858514`*^9}, {3.7631791726934657`*^9, 
   3.7631792506927533`*^9}, {3.763179356571133*^9, 3.763179368188118*^9}, {
   3.76317939949063*^9, 3.7631796455671964`*^9}, {3.7631796861331124`*^9, 
   3.763179719888902*^9}, {3.76317975187799*^9, 3.763179755557012*^9}, {
   3.7631801817923737`*^9, 3.76318019053231*^9}, {3.763180226469741*^9, 
   3.7631802325325713`*^9}, {3.7631805162693577`*^9, 3.763180554041701*^9}, {
   3.763180611819759*^9, 3.763180657444553*^9}, {3.763180715637886*^9, 
   3.763180776188592*^9}, {3.76318080978233*^9, 3.763180842643031*^9}, {
   3.7631816805778236`*^9, 3.763181736298154*^9}, {3.763181778287284*^9, 
   3.7631818116619997`*^9}, {3.7632072744455333`*^9, 
   3.7632073583081512`*^9}, {3.763207439890463*^9, 3.7632074554777412`*^9}, {
   3.7632078064653373`*^9, 3.763207967449655*^9}, {3.763209130098481*^9, 
   3.763209155768304*^9}, {3.763349418876359*^9, 3.763349450346298*^9}, {
   3.76334948378403*^9, 3.7633496860911818`*^9}, {3.7633497486052227`*^9, 
   3.7633497489595165`*^9}, {3.7633497911832266`*^9, 3.763349813790909*^9}, {
   3.7633498547873507`*^9, 3.763350033107644*^9}, {3.763350147563487*^9, 
   3.763350147959771*^9}, {3.763350189625988*^9, 3.7633502401177387`*^9}, {
   3.763350288476508*^9, 3.7633502943774347`*^9}, {3.763386428318741*^9, 
   3.7633864402352858`*^9}, 3.763469868464693*^9, {3.763482978417521*^9, 
   3.7634829803383236`*^9}, {3.7635255809456325`*^9, 
   3.7635255817947655`*^9}, {3.7635292324612355`*^9, 3.763529273050727*^9}, {
   3.763617023295188*^9, 3.7636170765621147`*^9}, {3.7636173132356815`*^9, 
   3.763617341960353*^9}, {3.763617458273432*^9, 3.7636174596238556`*^9}, 
   3.7637014734827003`*^9, {3.763701533532858*^9, 3.7637015761106343`*^9}, {
   3.7637018804893246`*^9, 3.7637020015247436`*^9}, {3.7648436274490757`*^9, 
   3.7648438617621746`*^9}, {3.7648439031149673`*^9, 
   3.7648439825466504`*^9}, {3.764844021487183*^9, 3.7648440954766755`*^9}, {
   3.764844160757986*^9, 3.7648441632271533`*^9}, {3.7648442292760563`*^9, 
   3.764844267018894*^9}, {3.7648443204973965`*^9, 3.764844330340141*^9}, {
   3.764844613597972*^9, 3.7648446292029057`*^9}, {3.7649053862230473`*^9, 
   3.7649053965701056`*^9}, {3.7651024401931286`*^9, 3.765102636440161*^9}, {
   3.765102668496835*^9, 3.7651027031063366`*^9}, {3.7651027514837446`*^9, 
   3.7651028592642384`*^9}, {3.765102931636056*^9, 3.7651029321059375`*^9}, {
   3.765120705900095*^9, 3.7651207604554405`*^9}, {3.765120795723405*^9, 
   3.765120850578637*^9}, {3.7651208929143705`*^9, 3.7651208977862587`*^9}, {
   3.765120948809183*^9, 3.7651215891395245`*^9}, {3.765121706480386*^9, 
   3.7651218357645698`*^9}, {3.7651219388572745`*^9, 3.765122137373032*^9}, 
   3.7651221702420597`*^9, {3.765122283480262*^9, 3.7651222849526997`*^9}, {
   3.765122356800682*^9, 3.765122358789372*^9}, {3.7651224529596753`*^9, 
   3.7651224585409355`*^9}, {3.765122497936124*^9, 3.7651225239475164`*^9}, {
   3.7651225721098924`*^9, 3.7651226580410805`*^9}, {3.7651226987779074`*^9, 
   3.7651227069069138`*^9}, {3.7651227463963337`*^9, 3.765122912408036*^9}, {
   3.7651229458781757`*^9, 3.765122946127627*^9}, 3.7651229845747795`*^9, {
   3.7651230569773855`*^9, 3.7651231169082685`*^9}, {3.7651231615603757`*^9, 
   3.765123179444669*^9}, {3.7651232289015155`*^9, 3.7651232756631727`*^9}, {
   3.7651233185134945`*^9, 3.765123322492734*^9}, {3.7651233659735904`*^9, 
   3.765123551554578*^9}, {3.765123638855879*^9, 3.7651236452709627`*^9}, {
   3.7651237070940795`*^9, 3.765123803611232*^9}, {3.765123844485327*^9, 
   3.765123855931971*^9}, {3.765123907071292*^9, 3.765123949034086*^9}, {
   3.7651239895523615`*^9, 3.7651239988940625`*^9}, {3.7651240941265745`*^9, 
   3.765124103036022*^9}, {3.7651242049330325`*^9, 3.7651242200437584`*^9}, {
   3.7651242609576674`*^9, 3.7651242854796295`*^9}, {3.765124327928507*^9, 
   3.7651243423529572`*^9}, {3.765124382710123*^9, 3.765124394657981*^9}, {
   3.765125273143955*^9, 3.7651252862797813`*^9}, {3.765125371504407*^9, 
   3.7651254376408415`*^9}, {3.765125541249239*^9, 3.765125546137782*^9}, {
   3.7651270488934727`*^9, 3.765127066387898*^9}, {3.765127107301261*^9, 
   3.7651271591998134`*^9}, {3.7651272180807915`*^9, 
   3.7651272475635586`*^9}, {3.765127278625615*^9, 3.7651272849429817`*^9}, {
   3.7651273253396006`*^9, 3.7651274220262566`*^9}, {3.765127532850821*^9, 
   3.7651276425246267`*^9}, {3.765127764730195*^9, 3.765127816137493*^9}, {
   3.765127876406419*^9, 3.7651278792921047`*^9}, {3.765183588008416*^9, 
   3.7651835934918146`*^9}, {3.7651836781976137`*^9, 3.765183678329157*^9}, {
   3.7651972643779364`*^9, 3.7651972656971235`*^9}, 3.7651973130763555`*^9, {
   3.765244039952422*^9, 3.7652441713625946`*^9}, 3.7656046891228895`*^9, {
   3.765605169596727*^9, 3.7656051869289145`*^9}, {3.7656052178450904`*^9, 
   3.765605355802777*^9}, {3.7656054128730993`*^9, 3.765605509868412*^9}, {
   3.7656055511738005`*^9, 3.765605662044302*^9}, {3.765605706531598*^9, 
   3.7656057066318665`*^9}, {3.7656058103157487`*^9, 
   3.7656058998290358`*^9}, {3.7656060166107416`*^9, 
   3.7656061414056387`*^9}, {3.76560617958871*^9, 3.765606258095722*^9}, {
   3.765606410938998*^9, 3.7656064289578977`*^9}, {3.7656065047201633`*^9, 
   3.765606590190341*^9}, {3.7656067017936816`*^9, 3.7656067086340837`*^9}, {
   3.7656067445476465`*^9, 3.7656069149294653`*^9}, {3.765606949786461*^9, 
   3.7656071547686844`*^9}, {3.7656072529598656`*^9, 3.765607298681075*^9}, {
   3.7656073551502595`*^9, 3.76560735872222*^9}, {3.7656142232332964`*^9, 
   3.765614238638157*^9}, {3.765614332343625*^9, 3.7656144970830593`*^9}, {
   3.765614537731634*^9, 3.765614695248723*^9}, {3.7656147305777884`*^9, 
   3.765614738020281*^9}, {3.765615038746632*^9, 3.765615208429484*^9}, {
   3.765615267163872*^9, 3.765615288715814*^9}, {3.765615802840268*^9, 
   3.76561591605848*^9}, {3.7656159662451305`*^9, 3.7656159784409647`*^9}, {
   3.765616035209815*^9, 3.7656160355327487`*^9}, {3.7656245747027073`*^9, 
   3.7656246754641724`*^9}, {3.7656247078002243`*^9, 3.76562475154808*^9}, {
   3.765624854910932*^9, 3.765624870212613*^9}, {3.7656249124796724`*^9, 
   3.7656249295990915`*^9}, {3.7656249781805897`*^9, 
   3.7656249965414906`*^9}, {3.765625029448327*^9, 3.765625096751483*^9}, {
   3.765625142251569*^9, 3.765625184049569*^9}, {3.7656252154482985`*^9, 
   3.7656252190891895`*^9}, 3.765625486060663*^9, {3.7656255343605213`*^9, 
   3.7656255589032726`*^9}, {3.7656256342483788`*^9, 
   3.7656256410104866`*^9}, {3.765625677447238*^9, 3.765625706413635*^9}, {
   3.7656257491726704`*^9, 3.765625787672994*^9}, {3.765625861790412*^9, 
   3.7656258697279105`*^9}, 3.765625964541379*^9, {3.7656261260083036`*^9, 
   3.7656261614358063`*^9}, {3.765626198735205*^9, 3.7656262122566442`*^9}, {
   3.7656263224296017`*^9, 3.7656263542492228`*^9}, {3.765626576380703*^9, 
   3.7656265986582365`*^9}, 3.765626635091218*^9, {3.7656309676361885`*^9, 
   3.7656310429508715`*^9}, {3.7656310921633525`*^9, 
   3.7656311451769667`*^9}, {3.765973440202033*^9, 3.765973531725689*^9}, {
   3.7659736528782196`*^9, 3.7659737005744925`*^9}, {3.7659750535874014`*^9, 
   3.7659750966601844`*^9}, {3.7659751731891966`*^9, 
   3.7659751776639805`*^9}, {3.765975322073573*^9, 3.76597536964876*^9}, {
   3.76597552541776*^9, 3.7659755613490076`*^9}, {3.7659756551803217`*^9, 
   3.765975663201084*^9}, {3.765975700187111*^9, 3.7659757092283096`*^9}, {
   3.765975772377339*^9, 3.765975816353572*^9}, {3.766064491319645*^9, 
   3.766064704310463*^9}, {3.7660650189849215`*^9, 3.766065022939865*^9}, {
   3.7660652317457395`*^9, 3.7660652334282756`*^9}, {3.7661591882503157`*^9, 
   3.766159188519918*^9}, {3.766159218666586*^9, 3.7661592233792944`*^9}, {
   3.76615927156651*^9, 3.7661593250623026`*^9}, {3.766244472361162*^9, 
   3.7662445541042347`*^9}, {3.766244602169401*^9, 3.766244603657547*^9}, {
   3.766244639082367*^9, 3.7662446462726808`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Qz = \\!\\(\\*SubsuperscriptBox[\\(\[Integral]\\), \\(0\\), \
\\(L\\)]\\)\\!\\(\\*SuperscriptBox[\\(Nxz\\), \\(T\\)]\\)qz\[DifferentialD]x \
= qzL\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "2"]},
       {
        RowBox[{"-", 
         FractionBox["L", "12"]}]},
       {
        FractionBox["1", "2"]},
       {
        FractionBox["L", "12"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Qz = \!\(\*SubsuperscriptBox[\(\[Integral]\), \(0\), \
\(L\)]\)\!\(\*SuperscriptBox[\(Nxz\), \(T\)]\)qz\[DifferentialD]x = qzL", 
   MatrixForm[{{
      Rational[1, 2]}, {Rational[-1, 12] $CellContext`L}, {
      Rational[1, 2]}, {Rational[1, 12] $CellContext`L}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.766159224435526*^9, {3.7661592994134665`*^9, 3.7661593281329226`*^9}, {
   3.766244520447963*^9, 3.7662445585362663`*^9}, 3.7662446148638587`*^9, 
   3.766244650046876*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Qy = \\!\\(\\*SubsuperscriptBox[\\(\[Integral]\\), \\(0\\), \
\\(L\\)]\\)\\!\\(\\*SuperscriptBox[\\(Nxy\\), \\(T\\)]\\)qy\[DifferentialD]x \
= qyL\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "2"]},
       {
        FractionBox["L", "12"]},
       {
        FractionBox["1", "2"]},
       {
        RowBox[{"-", 
         FractionBox["L", "12"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Qy = \!\(\*SubsuperscriptBox[\(\[Integral]\), \(0\), \
\(L\)]\)\!\(\*SuperscriptBox[\(Nxy\), \(T\)]\)qy\[DifferentialD]x = qyL", 
   MatrixForm[{{
      Rational[1, 2]}, {Rational[1, 12] $CellContext`L}, {
      Rational[1, 2]}, {Rational[-1, 12] $CellContext`L}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.766159224435526*^9, {3.7661592994134665`*^9, 3.7661593281329226`*^9}, {
   3.766244520447963*^9, 3.7662445585362663`*^9}, 3.7662446148638587`*^9, 
   3.766244650093747*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Qz = \\!\\(\\*SuperscriptBox[\\(Nxz\\), \\(T\\)]\\)(a)*Fz = Fz\
\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "3"]}], 
          SuperscriptBox["L", "3"]], "-", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["L", "2"]]}]},
       {
        RowBox[{
         RowBox[{"-", "a"}], "-", 
         FractionBox[
          SuperscriptBox["a", "3"], 
          SuperscriptBox["L", "2"]], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "L"]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["a", "3"]}], 
           SuperscriptBox["L", "3"]]}], "+", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["L", "2"]]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["a", "3"], 
           SuperscriptBox["L", "2"]]}], "+", 
         FractionBox[
          SuperscriptBox["a", "2"], "L"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Qz = \!\(\*SuperscriptBox[\(Nxz\), \(T\)]\)(a)*Fz = Fz", 
   MatrixForm[{{
     1 + 2 $CellContext`a^3 $CellContext`L^(-3) - 
      3 $CellContext`a^2 $CellContext`L^(-2)}, {-$CellContext`a - \
$CellContext`a^3 $CellContext`L^(-2) + 
      2 $CellContext`a^2/$CellContext`L}, {(-2) $CellContext`a^3 \
$CellContext`L^(-3) + 
      3 $CellContext`a^2 $CellContext`L^(-2)}, {-$CellContext`a^3 \
$CellContext`L^(-2) + $CellContext`a^2/$CellContext`L}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.766159224435526*^9, {3.7661592994134665`*^9, 3.7661593281329226`*^9}, {
   3.766244520447963*^9, 3.7662445585362663`*^9}, 3.7662446148638587`*^9, 
   3.766244650093747*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Qy = \\!\\(\\*SuperscriptBox[\\(Nxy\\), \\(T\\)]\\)(a)*Fy = Fy\
\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "3"]}], 
          SuperscriptBox["L", "3"]], "-", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["L", "2"]]}]},
       {
        RowBox[{"a", "+", 
         FractionBox[
          SuperscriptBox["a", "3"], 
          SuperscriptBox["L", "2"]], "-", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "L"]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["a", "3"]}], 
           SuperscriptBox["L", "3"]]}], "+", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["L", "2"]]}]},
       {
        RowBox[{
         FractionBox[
          SuperscriptBox["a", "3"], 
          SuperscriptBox["L", "2"]], "-", 
         FractionBox[
          SuperscriptBox["a", "2"], "L"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Qy = \!\(\*SuperscriptBox[\(Nxy\), \(T\)]\)(a)*Fy = Fy", 
   MatrixForm[{{
     1 + 2 $CellContext`a^3 $CellContext`L^(-3) - 
      3 $CellContext`a^2 $CellContext`L^(-2)}, {$CellContext`a + \
$CellContext`a^3 $CellContext`L^(-2) - 
      2 $CellContext`a^2/$CellContext`L}, {(-2) $CellContext`a^3 \
$CellContext`L^(-3) + 
      3 $CellContext`a^2 $CellContext`L^(-2)}, {$CellContext`a^3 \
$CellContext`L^(-2) - $CellContext`a^2/$CellContext`L}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.766159224435526*^9, {3.7661592994134665`*^9, 3.7661593281329226`*^9}, {
   3.766244520447963*^9, 3.7662445585362663`*^9}, 3.7662446148638587`*^9, 
   3.7662446501096745`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Qz = -\\!\\(\\*FractionBox[\\(\\*SuperscriptBox[\\(dNxz\\), \
\\(T\\)] \\((a)\\)\\), \\(dx\\)]\\)*My = My\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"6", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["L", "3"]]}], "+", 
         FractionBox[
          RowBox[{"6", " ", "a"}], 
          SuperscriptBox["L", "2"]]}]},
       {
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["L", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", "a"}], "L"]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["L", "3"]], "-", 
         FractionBox[
          RowBox[{"6", " ", "a"}], 
          SuperscriptBox["L", "2"]]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["L", "2"]], "-", 
         FractionBox[
          RowBox[{"2", " ", "a"}], "L"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Qz = -\!\(\*FractionBox[\(\*SuperscriptBox[\(dNxz\), \(T\)] \((a)\)\), \
\(dx\)]\)*My = My", 
   MatrixForm[{{(-6) $CellContext`a^2 $CellContext`L^(-3) + 
      6 $CellContext`a $CellContext`L^(-2)}, {
     1 + 3 $CellContext`a^2 $CellContext`L^(-2) - 
      4 $CellContext`a/$CellContext`L}, {
     6 $CellContext`a^2 $CellContext`L^(-3) - 
      6 $CellContext`a $CellContext`L^(-2)}, {
     3 $CellContext`a^2 $CellContext`L^(-2) - 
      2 $CellContext`a/$CellContext`L}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.766159224435526*^9, {3.7661592994134665`*^9, 3.7661593281329226`*^9}, {
   3.766244520447963*^9, 3.7662445585362663`*^9}, 3.7662446148638587`*^9, 
   3.7662446501117244`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Qy = -\\!\\(\\*FractionBox[\\(\\*SuperscriptBox[\\(dNxy\\), \
\\(T\\)] \\((a)\\)\\), \\(dx\\)]\\)*Mz = Mz\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"6", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["L", "3"]]}], "+", 
         FractionBox[
          RowBox[{"6", " ", "a"}], 
          SuperscriptBox["L", "2"]]}]},
       {
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["L", "2"]], "+", 
         FractionBox[
          RowBox[{"4", " ", "a"}], "L"]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["L", "3"]], "-", 
         FractionBox[
          RowBox[{"6", " ", "a"}], 
          SuperscriptBox["L", "2"]]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"3", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["L", "2"]]}], "+", 
         FractionBox[
          RowBox[{"2", " ", "a"}], "L"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Qy = -\!\(\*FractionBox[\(\*SuperscriptBox[\(dNxy\), \(T\)] \((a)\)\), \
\(dx\)]\)*Mz = Mz", 
   MatrixForm[{{(-6) $CellContext`a^2 $CellContext`L^(-3) + 
      6 $CellContext`a $CellContext`L^(-2)}, {-1 - 
      3 $CellContext`a^2 $CellContext`L^(-2) + 
      4 $CellContext`a/$CellContext`L}, {
     6 $CellContext`a^2 $CellContext`L^(-3) - 
      6 $CellContext`a $CellContext`L^(-2)}, {(-3) $CellContext`a^2 \
$CellContext`L^(-2) + 2 $CellContext`a/$CellContext`L}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.766159224435526*^9, {3.7661592994134665`*^9, 3.7661593281329226`*^9}, {
   3.766244520447963*^9, 3.7662445585362663`*^9}, 3.7662446148638587`*^9, 
   3.7662446501117244`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1920, 997},
WindowMargins->{{1912, Automatic}, {Automatic, -8}},
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 7, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 22439, 452, 751, "Input"],
Cell[CellGroupData[{
Cell[23043, 478, 1486, 39, 123, "Print"],
Cell[24532, 519, 1486, 39, 123, "Print"],
Cell[26021, 560, 2500, 70, 137, "Print"],
Cell[28524, 632, 2447, 68, 137, "Print"],
Cell[30974, 702, 2475, 69, 137, "Print"],
Cell[33452, 773, 2523, 70, 137, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
